<?php

/*
Plugin Name: mogu safe login
Plugin URI: http://www.mogublog.net/
Description: Wordpress 登录保护插件 By mogublog
Author: mogublog
Version: 0.1
Author URI: http://www.mogublog.net/
*/


/* 
 *  登录失败的时候记录IP
 */
function mogu_safe_login_failed($username){
	$log = mogu_safe_login_get_log();
	if(file_exists($log)){
		file_put_contents($log, file_get_contents($log) + 1);
	}else{
		file_put_contents($log, 1);
	}
}

add_action('wp_login_failed', 'mogu_safe_login_failed');


/* 
 *  登录的时候检查IP
 */
function mogu_safe_login_authenticate($user, $username, $password){
	$log = mogu_safe_login_get_log();
	if(file_exists($log)){
		if(file_get_contents($log) > 4){
			return new WP_ERROR('mogu_login_failed', '您的IP已被锁定，无法登录，请联系管理员！');
		}
	}
	return $user;
}

add_filter('authenticate', 'mogu_safe_login_authenticate', 20, 3);


/* 
 *  格式化IP地址
 */
function mogu_safe_login_get_ip(){
	$ip = explode('.', $_SERVER['REMOTE_ADDR']);
	if(count($ip) != 4){
		return false;
	}
	$tmp = '';
	foreach($ip as $v){
		$tmp .= intval($v).'.';
	}
	$ip = substr($tmp, 0, -1);
	return $ip;
}

/* 
 *  获取IP的记录地址
 */
function mogu_safe_login_get_log(){
	$ip = mogu_safe_login_get_ip();
	$array = explode('.', $ip);
	$work = WP_CONTENT_DIR.'/cache/mogu_safe_login/'.$array[0];
	if(!file_exists($work)){
		mkdir($work, 0755, true);
	}
	return $work.'/'.$ip;
}
